/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.DistanceProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.TextElement;

public class EntityDetailsBodyProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        int passengers;
        String key;
        if (!config.get(JadeIds.ACCESS_ENTITY_DETAILS)) {
            return;
        }
        Entity entity = accessor.getEntity();
        int poseId = EntityDetailsBodyProvider.getPoseId(entity);
        if (poseId != Pose.STANDING.id() && I18n.exists((String)(key = "jade.access.entity.pose.%s".formatted(poseId)))) {
            tooltip.add((Component)Component.translatable((String)"jade.access.entity.pose", (Object[])new Object[]{Component.translatable((String)key)}));
        }
        if ((passengers = entity.getPassengers().size()) > 0) {
            tooltip.add((Component)JadeClient.format("jade.access.entity.passengers", passengers));
        }
        if (entity instanceof Leashable) {
            List leashables;
            Leashable leashable = (Leashable)entity;
            if (leashable.isLeashed()) {
                Entity holder = leashable.getLeashHolder();
                if (holder instanceof LeashFenceKnotEntity) {
                    LeashFenceKnotEntity knot = (LeashFenceKnotEntity)holder;
                    TextElement text = DistanceProvider.xyz((Vec3i)knot.blockPosition());
                    tooltip.add(JadeUI.text((Component)Component.translatable((String)"jade.access.entity.leashed_to", (Object[])new Object[]{text.getString()})).narration((Component)Component.translatable((String)"jade.access.entity.leashed_to", (Object[])new Object[]{text.getString()})));
                } else if (holder != null) {
                    tooltip.add((Component)Component.translatable((String)"jade.access.entity.leashed_to", (Object[])new Object[]{holder.getName()}));
                }
            }
            if (!(leashables = Leashable.leashableLeashedTo((Entity)entity)).isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"jade.access.entity.is_leashing", (Object[])new Object[]{ComponentUtils.formatList((Collection)leashables, (Component)Component.literal((String)", "), $ -> ((Entity)$).getDisplayName())}));
            }
        }
    }

    private static int getPoseId(Entity entity) {
        int poseId = entity.getPose().id();
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TamableAnimal.class, Panda.class, Camel.class, Fox.class, Axolotl.class, Armadillo.class}, (Object)entity3, n)) {
                case 0: {
                    TamableAnimal animal = (TamableAnimal)entity3;
                    if (!animal.isInSittingPose()) {
                        n = 1;
                        continue block8;
                    }
                    poseId = Pose.SITTING.id();
                    break block8;
                }
                case 1: {
                    Panda panda = (Panda)entity3;
                    if (!panda.isSitting()) {
                        n = 2;
                        continue block8;
                    }
                    poseId = Pose.SITTING.id();
                    break block8;
                }
                case 2: {
                    Camel camel = (Camel)entity3;
                    if (!camel.isCamelSitting()) {
                        n = 3;
                        continue block8;
                    }
                    poseId = Pose.SITTING.id();
                    break block8;
                }
                case 3: {
                    Fox fox = (Fox)entity3;
                    if (fox.isSleeping()) {
                        poseId = Pose.SLEEPING.id();
                        break block8;
                    }
                    if (!fox.isSitting()) break block8;
                    poseId = Pose.SITTING.id();
                    break block8;
                }
                case 4: {
                    Axolotl axolotl = (Axolotl)entity3;
                    if (!axolotl.isPlayingDead()) {
                        n = 5;
                        continue block8;
                    }
                    poseId = 1000;
                    break block8;
                }
                case 5: {
                    Armadillo armadillo = (Armadillo)entity3;
                    if (armadillo.getState() != Armadillo.ArmadilloState.ROLLING) {
                        n = 6;
                        continue block8;
                    }
                    poseId = 1001;
                    break block8;
                }
            }
            break;
        }
        return poseId;
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS_BODY;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return 3333;
    }
}

